	page    132,60
;****************************************************************************
;	INOUT.ASM
;	Example program to evaluate CODEC I/O
; 
;******************************************************************************

	include 'codec.asm'

;******************************************************************************
TONE_OUTPUT     EQU     HEADPHONE_EN+LINEOUT_EN+(4*LEFT_ATTN)+(4*RIGHT_ATTN)   
TONE_INPUT      EQU     MIC_IN_SELECT+(15*MONITOR_ATTN)

;******************************************************************************
       org     x:      
LEFT_sig        ds      1       ;storage for Left Signal
RIGHT_sig       ds      1       ;storage for Left Signal

;******************************************************************************
       org     y:


;******************************************************************************
	org     p:
main
; Initialize SC0, SC1 as GPIO inputs, Connected to optional terminal port    
    	bclr    #0,x:PCC                 ; SC0 - GPIO (PC0)
    	bclr    #1,x:PCC                 ; SC1 - GPIO (PC1)
    	bclr    #0,x:PCDDR               ; SC0 (PC0) - input
    	bclr    #1,x:PCDDR               ; SC1 (PC1) - input

	movep   #$fb00,x:CRB            ; Enable the SSI interrupts.
	movep	#$301b,x:IPR		; IRQA/IRQB/SSI are level 3 interrupts.
					; and are LEVEL sensitive
	
;
; Program headphone,lineout enabled, speaker off, attn=0
; Does this need to done on evey cycle or once in the beginning?
;
	move    #TONE_OUTPUT,y0         ; headphones, line out, 
					; mute spkr, no attn.
	move    y0,x:TX_BUFF_BASE+2
	move    #TONE_INPUT,y0          ; no input gain, monitor mute
	move    y0,x:TX_BUFF_BASE+3

; Main Loop
loop_1 
	jset    #2,x:SSISR,*            ; Wait for frame sync to pass.
	jclr    #2,x:SSISR,*            ; Wait for frame sync.

	move    x:RX_BUFF_BASE,a        ; Load the left channel input.
	move    x:RX_BUFF_BASE+1,b      ; Load the right channel input.
	
	move    a,x:TX_BUFF_BASE        ; Put value in left channel tx.
	move    b,x:TX_BUFF_BASE+1      ; Put value in right channel tx.  
	
	jmp     loop_1                  ; Loop back.


;*************************************************************************************

    end
